/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.te;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.types.Ore;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.Gem;
import net.dries007.tfc.objects.blocks.devices.BlockSluice;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.dries007.tfc.objects.items.ItemGem;
import net.dries007.tfc.objects.items.metal.ItemSmallOre;
import net.dries007.tfc.objects.te.TEBase;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.dries007.tfc.world.classic.worldgen.vein.Vein;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class TESluice
extends TEBase
implements ITickable {
    public static final int MAX_SOIL = 50;
    private int soil;
    private int ticksRemaining;
    private int delayTimer;

    public static boolean isValidFluid(Fluid fluid) {
        return fluid == FluidsTFC.FRESH_WATER.get() || fluid == FluidsTFC.SALT_WATER.get();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticksRemaining > 0 && --this.ticksRemaining <= 0) {
                ChunkDataTFC chunkData;
                if (Constants.RNG.nextDouble() < ConfigTFC.Devices.SLUICE.oreChance) {
                    chunkData = this.getChunkData(true);
                    if (chunkData != null) {
                        List veinList = chunkData.getGeneratedVeins().stream().filter(vein -> vein.getType() != null && vein.getType().getOre() != null).collect(Collectors.toList());
                        Ore ore = ((Vein)veinList.get(Constants.RNG.nextInt(veinList.size()))).getType().getOre();
                        ItemStack output = new ItemStack((Item)ItemSmallOre.get(ore));
                        Helpers.spawnItemStack(this.field_145850_b, this.getFrontWaterPos(), output);
                        chunkData.addWork(3);
                    }
                } else if (Constants.RNG.nextDouble() < ConfigTFC.Devices.SLUICE.gemChance && (chunkData = this.getChunkData(false)) != null) {
                    Gem dropGem = Constants.RNG.nextDouble() < ConfigTFC.Devices.SLUICE.diamondGemChance ? Gem.DIAMOND : Gem.getRandomDropGem(Constants.RNG);
                    Gem.Grade grade = Gem.Grade.randomGrade(Constants.RNG);
                    Helpers.spawnItemStack(this.field_145850_b, this.getFrontWaterPos(), ItemGem.get(dropGem, grade, 1));
                    chunkData.addWork(3);
                }
                this.consumeSoil();
            }
            if (--this.delayTimer <= 0) {
                BlockPos frontPos;
                this.delayTimer = 20;
                Fluid flowing = this.getFlowingFluid();
                if (flowing != null && TESluice.isValidFluid(flowing) && this.field_145850_b.func_180495_p(frontPos = this.getFrontWaterPos()).func_185904_a().func_76222_j()) {
                    this.field_145850_b.func_175656_a(frontPos, flowing.getBlock().func_176223_P());
                }
                if (this.soil < 50) {
                    for (EntityItem entityItem : this.field_145850_b.func_175647_a(EntityItem.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(1.0), EntitySelectors.field_94557_a)) {
                        BlockRockVariant rockBlock;
                        ItemStack stack = entityItem.func_92059_d();
                        if (!(stack.func_77973_b() instanceof ItemBlock) || !(((ItemBlock)stack.func_77973_b()).func_179223_d() instanceof BlockRockVariant) || (rockBlock = (BlockRockVariant)((ItemBlock)stack.func_77973_b()).func_179223_d()).getType() != Rock.Type.SAND && rockBlock.getType() != Rock.Type.GRAVEL) continue;
                        this.soil += 20;
                        stack.func_190918_g(1);
                        if (stack.func_190916_E() <= 0) {
                            entityItem.func_70106_y();
                            break;
                        }
                        this.markForBlockUpdate();
                    }
                }
                if (this.ticksRemaining <= 0) {
                    this.consumeSoil();
                }
            }
        }
    }

    @Nullable
    public Fluid getFlowingFluid() {
        BlockFluidBase block = this.getFlowingFluidBlock();
        return block == null ? null : block.getFluid();
    }

    @Nullable
    public EnumFacing getBlockFacing() {
        if (!this.func_145830_o() || !(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockSluice)) {
            return null;
        }
        return (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockHorizontal.field_185512_D);
    }

    public void func_145839_a(@Nonnull NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.soil = nbt.func_74762_e("soil");
        this.ticksRemaining = nbt.func_74762_e("ticksRemaining");
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("soil", this.soil);
        nbt.func_74768_a("ticksRemaining", this.ticksRemaining);
        return super.func_189515_b(nbt);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public int getSoil() {
        return this.soil;
    }

    @Nullable
    private BlockFluidBase getFlowingFluidBlock() {
        if (!this.func_145830_o() || !(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockSluice)) {
            return null;
        }
        EnumFacing sluiceFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockHorizontal.field_185512_D);
        BlockPos fluidInputPos = this.field_174879_c.func_177984_a().func_177972_a(sluiceFacing);
        IBlockState state = this.field_145850_b.func_180495_p(fluidInputPos);
        Block block = state.func_177230_c();
        if (block instanceof BlockFluidBase) {
            return (BlockFluidBase)block;
        }
        return null;
    }

    private BlockPos getFrontWaterPos() {
        return this.field_174879_c.func_177977_b().func_177967_a(this.getBlockFacing().func_176734_d(), 2);
    }

    private boolean hasFlow() {
        Fluid fluid = this.getFlowingFluid();
        if (fluid == null || !TESluice.isValidFluid(fluid)) {
            return false;
        }
        IBlockState frontState = this.field_145850_b.func_180495_p(this.getFrontWaterPos());
        Block block = frontState.func_177230_c();
        if (block instanceof BlockFluidBase) {
            return ((BlockFluidBase)block).getFluid() == fluid;
        }
        return false;
    }

    private void consumeSoil() {
        if (this.soil > 0 && this.hasFlow()) {
            --this.soil;
            this.ticksRemaining = ConfigTFC.Devices.SLUICE.ticks;
            this.markForBlockUpdate();
        } else {
            this.ticksRemaining = 0;
            if (this.soil > 0) {
                this.soil = 0;
                this.markForBlockUpdate();
            }
        }
    }

    private ChunkDataTFC getChunkData(boolean checkVeins) {
        ChunkPos myPos = this.field_145850_b.func_175726_f(this.field_174879_c).func_76632_l();
        int radius = ConfigTFC.Devices.SLUICE.radius;
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        for (int x = myPos.field_77276_a - radius; x <= myPos.field_77276_a + radius; ++x) {
            for (int z = myPos.field_77275_b - radius; z <= myPos.field_77275_b + radius; ++z) {
                Chunk chunk = this.field_145850_b.func_72964_e(x, z);
                ChunkDataTFC chunkData = ChunkDataTFC.get(chunk);
                if (!chunkData.canWork(1) || checkVeins && !chunkData.getGeneratedVeins().stream().anyMatch(vein -> vein.getType() != null && vein.getType().getOre() != null)) continue;
                chunks.add(chunk);
            }
        }
        if (chunks.size() > 0) {
            Chunk workingChunk = (Chunk)chunks.get(Constants.RNG.nextInt(chunks.size()));
            return ChunkDataTFC.get(workingChunk);
        }
        return null;
    }
}

